<!DOCTYPE html>
<html>

% include('header_intro.tpl', title='Information about the study', parameter = para)


<body>
    <div class="container">
		<h1>About the study</h1>

		<article>
			<h2>Intro</h2> 
			<p>
				This study intends to measure the perception of differences in the design of lettershapes. Some of these differences can be classified as design parameters. You will be asked to judge which one of two stimuli has a higher value on one of these parameters. In this experiment the parameters is {{ 'slant' if para.startswith('slant') else para }}.
			</p>
		</article>

		<article>
			<h2>About {{ 'slant' if para.startswith('slant') else para }}</h2>
			<p>{{ para_info }}</p>
			<figure>
				<img src="/assets/imgs/ranges/{{ para }}_range.png" alt="Left and right endpoints overlapped">
				<figcaption>A range of instances from lowest to highest {{ 'slant' if para.startswith('slant') else para }}.</figcaption>
			</figure>
		</article>

		<article>
			<h2>The trial setup</h2>
            <p>You will be presented two randomly selected english words. They are set in slightly different fonts. The font of either the left or the right word has a greater {{ 'slant' if para.startswith('slant') else para }}. You are asked to select which one is higher.
			</p>
            
			<figure>
				<img src="/assets/imgs/JND_examples/{{ para }}_0.png" alt="The {{ para }} is higher in the left word.">
				<figcaption>The {{ 'slant' if para.startswith('slant') else para }} is higher in the left word.</figcaption>
				<img src="/assets/imgs/JND_examples/{{ para }}_1.png" alt="The {{ para }} is higher in the left word.">
				<figcaption>The {{ 'slant' if para.startswith('slant') else para }} is higher in the right word.</figcaption>
				<img src="/assets/imgs/JND_examples/{{ para }}_2.png" alt="The {{ para }} is higher in the left word.">
				<figcaption>The {{ 'slant' if para.startswith('slant') else para }} is higher in the left word.</figcaption>
			</figure>

            <p>You can select which one is higher by using the mouse to click one of the words or by using the keyboard’s arrow keys. Pressing the left or right key will change the selected word. </p>
            <img src="/assets/imgs/radio_input.gif" alt="Interact with the radio buttons">
            <p>If you are happy with your selection click the <span class='letter_spaced'>OK</span> button between the two words or hit the return key of your keyboard. You have to select a word to enable the <span class='letter_spaced'>OK</span> button. After you submitted your choice you will be taken to the next trial. Repeat the described procedure until you get to the finish page.</p>

            <h2>Example</h2>
            <p>You can test the keyboard or mouse input and trial setup on the example below.</p>

	        <form action="./ajax" method='post' id="the_form">
	          <input id ="left"  name='choose' type="radio" value="A" required>
	          <input id ="right" name='choose' type="radio" value="B" required><br>
	          <label for ="left"><span class="stimuli A range-label">smallest</span></label>
	          <label for ="right"><span class="stimuli B range-label">commands</span></label>
	          <input id="next_j" class="center" type="submit" value="OK" disabled>
	          <input type="hidden" name="axis_para_min" id="axis_para_min" value={{ axis_para[0] }}>
	          <input type="hidden" name="axis_para_max" id="axis_para_max" value={{ axis_para[1] }}>
	        </form>

		</article>

		<p>If you are ready to start the study press the <span class='letter_spaced'>START</span> button below.<br>
		<p>Please be accurate!</p>
    	<p><form action="./round1"><input type="submit" value="S T A R T"></form></p>

    </div>

    <script>var url_part = { exp: {{!'"%s"' % exp }}, para: {{!'"%s"' % para }} };</script>
    <script src='/assets/js/jquery-1.11.3.min.js'></script>
    <script src="/assets/js/JND_intro.js"></script>
    <script src="/assets/js/ok_placing.js"></script>

% include('footer.tpl')

</body>
</html>
